//Source file: H:\src\Alkindi\Services\Util\UserEvalData.java

package Alkindi.Services.InternalData;

import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;

/* 
$Header: UserEvalData.java, 8, 5/8/01 10:04:27 AM, Schwartz, Joe$
$Log: 
 8    Alkindi Development1.7         5/8/01 10:04:27 AM   Schwartz, Joe    
 7    Alkindi Development1.6         4/26/01 3:28:13 PM   Schwartz, Joe  
      Changed javadoc comments to correct references.
 6    Alkindi Development1.5         4/26/01 3:24:07 PM   Schwartz, Joe   Rolled
      back to version using SQLData interface.
 5    Alkindi Development1.4         4/26/01 2:37:00 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 4    Alkindi Development1.3         4/26/01 1:46:08 PM   Schwartz, Joe   Moved
      to new package.
 3    Alkindi Development1.2         2/19/01 6:15:13 PM   Schwartz, Joe    
 2    Alkindi Development1.1         2/16/01 5:49:09 PM   Schwartz, Joe   Added
      SQLData implementation. Modified class members to match Oracle UDTs.
 1    Alkindi Development1.0         2/15/01 6:57:42 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * Represents evaluation data for a specific user.<p>
 * This class implements the <tt>SQLData</tt> interface so it can parse itself from a <tt>SQLStream</tt>.<p>
 * In order to use the SQLData implementation features, the programmer must first make sure that the active SQL Data Type Map contains an entry for the SQL data type represented by this class. The programmer can modify either the map for the current connection or pass a custom map to the <tt>getObject()</tt> method.
 *  
 * @see java.sql.SQLData
 * @see java.sql.Connection
 * @see Alkindi.Services.ServicesImpl.RecommendationManager
 */
public class UserEvalData implements SQLData 
{
	
	/**
	 * The number of possible evaluations on the scale (currently 0-6).
	 */
	private static final int NUM_RATING_TYPES = 7;
	
	/**
	 * Number of "Don't Know" interest responses.
	 */
	public int numDunno = 0;
	
	/**
	 * Number of "No" interest responses.
	 */
	public int numNo = 0;
	
	/**
	 * Number of "Yes" interest responses.
	 */
	public int numYes = 0;
	public int ratingSums[] = new int [NUM_RATING_TYPES] ;
	
	/**
	 * The default name of the SQL user-defined type represented by this class.
	 */
	public static final String DEFAULT_SQL_TYPE = "ALKINDI.EVALSSTAT_T";
	
	/**
	 * The name of the SQL user-defined type represented by this class.
	 */
	private String sqlType = DEFAULT_SQL_TYPE;
	
	/**
	 * @roseuid 3AE870750177
	 */
	public UserEvalData() 
	{
		java.util.Arrays.fill(ratingSums, 0);
	}
	
	/**
	 * Calculates the average evaluation.
	 * @roseuid 3AE870750178
	 */
	public float avgEval() 
	{
		float sum = 0;
		float numEvals = 0;
		for (int idx = 1; idx < NUM_RATING_TYPES; idx++) {
			sum += idx * ratingSums[idx];
			numEvals += ratingSums[idx];
		}
		return sum / numEvals;
	}
	
	/**
	 * For implemenation of SQLData.
	 * @roseuid 3AE870750179
	 */
	public String getSQLTypeName() throws SQLException 
	{
		return sqlType;
	}
	
	/**
	 * @roseuid 3AE87075017A
	 */
	public float numShown() 
	{
		float shown = 0;
		for (int idx = 1; idx < NUM_RATING_TYPES; idx ++) {
			shown += ratingSums[idx];
		}
		return shown;
	}
	
	/**
	 * Calculates the fraction of products rated to those shown to the user.
	 * @roseuid 3AE870750186
	 */
	public float ratedToShown() 
	{
		//	Product is rated when it has an eval > 0;
		//	Product is shown when it has an eval >=0;
		float shown = 0;
		
		for (int idx = 1; idx < NUM_RATING_TYPES; idx++) {
			shown += ratingSums[idx];
		}
		return shown / (shown + ratingSums[0]);
	}
	
	/**
	 * For implemenation of SQLData. Populates the object attributes using the data read off of the supplied SQLInput stream.
	 * @roseuid 3AE870750187
	 */
	public void readSQL(SQLInput inStream, String typeName) throws SQLException 
	{
		sqlType = typeName;
		numDunno = inStream.readInt();
		numNo = inStream.readInt();
		numYes = inStream.readInt();
		for (int idx = 0; idx < NUM_RATING_TYPES; idx ++ ) {
			ratingSums[idx] = inStream.readInt();
		}
	}
	
	/**
	 * For implemenation of SQLData.
	 * @roseuid 3AE870750196
	 */
	public void writeSQL(SQLOutput outStream) throws SQLException 
	{
		outStream.writeInt(numDunno);
		outStream.writeInt(numNo);
		outStream.writeInt(numYes);
		for (int idx = 0; idx < NUM_RATING_TYPES; idx ++) {
			outStream.writeInt(ratingSums[idx]);
		}
	}
}
